var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/renderers/renderToStaticMarkup.tsx
import React5 from "react";
import { renderToStaticMarkup as baseRenderToStaticMarkup } from "react-dom/server";

// src/Reader/core.tsx
import React4, { createContext, useContext } from "react";
import { z as z4 } from "zod";
import { Avatar, AvatarPropsSchema } from "@usewaypoint/block-avatar";
import { Button, ButtonPropsSchema } from "@usewaypoint/block-button";
import { Divider, DividerPropsSchema } from "@usewaypoint/block-divider";
import { Heading, HeadingPropsSchema } from "@usewaypoint/block-heading";
import { Html, HtmlPropsSchema } from "@usewaypoint/block-html";
import { Image, ImagePropsSchema } from "@usewaypoint/block-image";
import { Spacer, SpacerPropsSchema } from "@usewaypoint/block-spacer";
import { Text, TextPropsSchema } from "@usewaypoint/block-text";
import {
  buildBlockComponent,
  buildBlockConfigurationDictionary,
  buildBlockConfigurationSchema
} from "@usewaypoint/document-core";

// src/blocks/ColumnsContainer/ColumnsContainerPropsSchema.ts
import { z } from "zod";
import { ColumnsContainerPropsSchema as BaseColumnsContainerPropsSchema } from "@usewaypoint/block-columns-container";
var BasePropsShape = BaseColumnsContainerPropsSchema.shape.props.unwrap().unwrap().shape;
var ColumnsContainerPropsSchema = z.object({
  style: BaseColumnsContainerPropsSchema.shape.style,
  props: z.object(__spreadProps(__spreadValues({}, BasePropsShape), {
    columns: z.tuple([
      z.object({ childrenIds: z.array(z.string()) }),
      z.object({ childrenIds: z.array(z.string()) }),
      z.object({ childrenIds: z.array(z.string()) })
    ])
  })).optional().nullable()
});
var ColumnsContainerPropsSchema_default = ColumnsContainerPropsSchema;

// src/blocks/ColumnsContainer/ColumnsContainerReader.tsx
import React from "react";
import { ColumnsContainer as BaseColumnsContainer } from "@usewaypoint/block-columns-container";
function ColumnsContainerReader({ style, props }) {
  const _a = props != null ? props : {}, { columns } = _a, restProps = __objRest(_a, ["columns"]);
  let cols = void 0;
  if (columns) {
    cols = columns.map((col) => col.childrenIds.map((childId) => /* @__PURE__ */ React.createElement(ReaderBlock, { key: childId, id: childId })));
  }
  return /* @__PURE__ */ React.createElement(BaseColumnsContainer, { props: restProps, columns: cols, style });
}

// src/blocks/Container/ContainerPropsSchema.tsx
import { z as z2 } from "zod";
import { ContainerPropsSchema as BaseContainerPropsSchema } from "@usewaypoint/block-container";
var ContainerPropsSchema = z2.object({
  style: BaseContainerPropsSchema.shape.style,
  props: z2.object({
    childrenIds: z2.array(z2.string()).optional().nullable()
  }).optional().nullable()
});

// src/blocks/Container/ContainerReader.tsx
import React2 from "react";
import { Container as BaseContainer } from "@usewaypoint/block-container";
function ContainerReader({ style, props }) {
  var _a;
  const childrenIds = (_a = props == null ? void 0 : props.childrenIds) != null ? _a : [];
  return /* @__PURE__ */ React2.createElement(BaseContainer, { style }, childrenIds.map((childId) => /* @__PURE__ */ React2.createElement(ReaderBlock, { key: childId, id: childId })));
}

// src/blocks/EmailLayout/EmailLayoutPropsSchema.tsx
import { z as z3 } from "zod";
var COLOR_SCHEMA = z3.string().regex(/^#[0-9a-fA-F]{6}$/).nullable().optional();
var FONT_FAMILY_SCHEMA = z3.enum([
  "MODERN_SANS",
  "BOOK_SANS",
  "ORGANIC_SANS",
  "GEOMETRIC_SANS",
  "HEAVY_SANS",
  "ROUNDED_SANS",
  "MODERN_SERIF",
  "BOOK_SERIF",
  "MONOSPACE"
]).nullable().optional();
var EmailLayoutPropsSchema = z3.object({
  backdropColor: COLOR_SCHEMA,
  borderColor: COLOR_SCHEMA,
  borderRadius: z3.number().optional().nullable(),
  canvasColor: COLOR_SCHEMA,
  textColor: COLOR_SCHEMA,
  fontFamily: FONT_FAMILY_SCHEMA,
  childrenIds: z3.array(z3.string()).optional().nullable()
});

// src/blocks/EmailLayout/EmailLayoutReader.tsx
import React3 from "react";
function getFontFamily(fontFamily) {
  const f = fontFamily != null ? fontFamily : "MODERN_SANS";
  switch (f) {
    case "MODERN_SANS":
      return '"Helvetica Neue", "Arial Nova", "Nimbus Sans", Arial, sans-serif';
    case "BOOK_SANS":
      return 'Optima, Candara, "Noto Sans", source-sans-pro, sans-serif';
    case "ORGANIC_SANS":
      return 'Seravek, "Gill Sans Nova", Ubuntu, Calibri, "DejaVu Sans", source-sans-pro, sans-serif';
    case "GEOMETRIC_SANS":
      return 'Avenir, "Avenir Next LT Pro", Montserrat, Corbel, "URW Gothic", source-sans-pro, sans-serif';
    case "HEAVY_SANS":
      return 'Bahnschrift, "DIN Alternate", "Franklin Gothic Medium", "Nimbus Sans Narrow", sans-serif-condensed, sans-serif';
    case "ROUNDED_SANS":
      return 'ui-rounded, "Hiragino Maru Gothic ProN", Quicksand, Comfortaa, Manjari, "Arial Rounded MT Bold", Calibri, source-sans-pro, sans-serif';
    case "MODERN_SERIF":
      return 'Charter, "Bitstream Charter", "Sitka Text", Cambria, serif';
    case "BOOK_SERIF":
      return '"Iowan Old Style", "Palatino Linotype", "URW Palladio L", P052, serif';
    case "MONOSPACE":
      return '"Nimbus Mono PS", "Courier New", "Cutive Mono", monospace';
  }
}
function getBorder({ borderColor }) {
  if (!borderColor) {
    return void 0;
  }
  return `1px solid ${borderColor}`;
}
function EmailLayoutReader(props) {
  var _a, _b, _c, _d, _e;
  const childrenIds = (_a = props.childrenIds) != null ? _a : [];
  return /* @__PURE__ */ React3.createElement(
    "div",
    {
      style: {
        backgroundColor: (_b = props.backdropColor) != null ? _b : "#F5F5F5",
        color: (_c = props.textColor) != null ? _c : "#262626",
        fontFamily: getFontFamily(props.fontFamily),
        fontSize: "16px",
        fontWeight: "400",
        letterSpacing: "0.15008px",
        lineHeight: "1.5",
        margin: "0",
        padding: "32px 0",
        minHeight: "100%",
        width: "100%"
      }
    },
    /* @__PURE__ */ React3.createElement(
      "table",
      {
        align: "center",
        width: "100%",
        style: {
          margin: "0 auto",
          maxWidth: "600px",
          backgroundColor: (_d = props.canvasColor) != null ? _d : "#FFFFFF",
          borderRadius: (_e = props.borderRadius) != null ? _e : void 0,
          border: getBorder(props)
        },
        role: "presentation",
        cellSpacing: "0",
        cellPadding: "0",
        border: 0
      },
      /* @__PURE__ */ React3.createElement("tbody", null, /* @__PURE__ */ React3.createElement("tr", { style: { width: "100%" } }, /* @__PURE__ */ React3.createElement("td", null, childrenIds.map((childId) => /* @__PURE__ */ React3.createElement(ReaderBlock, { key: childId, id: childId })))))
    )
  );
}

// src/Reader/core.tsx
var ReaderContext = createContext({});
function useReaderDocument() {
  return useContext(ReaderContext);
}
var READER_DICTIONARY = buildBlockConfigurationDictionary({
  ColumnsContainer: {
    schema: ColumnsContainerPropsSchema_default,
    Component: ColumnsContainerReader
  },
  Container: {
    schema: ContainerPropsSchema,
    Component: ContainerReader
  },
  EmailLayout: {
    schema: EmailLayoutPropsSchema,
    Component: EmailLayoutReader
  },
  //
  Avatar: {
    schema: AvatarPropsSchema,
    Component: Avatar
  },
  Button: {
    schema: ButtonPropsSchema,
    Component: Button
  },
  Divider: {
    schema: DividerPropsSchema,
    Component: Divider
  },
  Heading: {
    schema: HeadingPropsSchema,
    Component: Heading
  },
  Html: {
    schema: HtmlPropsSchema,
    Component: Html
  },
  Image: {
    schema: ImagePropsSchema,
    Component: Image
  },
  Spacer: {
    schema: SpacerPropsSchema,
    Component: Spacer
  },
  Text: {
    schema: TextPropsSchema,
    Component: Text
  }
});
var ReaderBlockSchema = buildBlockConfigurationSchema(READER_DICTIONARY);
var ReaderDocumentSchema = z4.record(z4.string(), ReaderBlockSchema);
var BaseReaderBlock = buildBlockComponent(READER_DICTIONARY);
function ReaderBlock({ id }) {
  const document = useReaderDocument();
  return /* @__PURE__ */ React4.createElement(BaseReaderBlock, __spreadValues({}, document[id]));
}
function Reader({ document, rootBlockId }) {
  return /* @__PURE__ */ React4.createElement(ReaderContext.Provider, { value: document }, /* @__PURE__ */ React4.createElement(ReaderBlock, { id: rootBlockId }));
}

// src/renderers/renderToStaticMarkup.tsx
function renderToStaticMarkup(document, { rootBlockId }) {
  return "<!DOCTYPE html>" + baseRenderToStaticMarkup(
    /* @__PURE__ */ React5.createElement("html", null, /* @__PURE__ */ React5.createElement("body", null, /* @__PURE__ */ React5.createElement(Reader, { document, rootBlockId })))
  );
}
export {
  Reader,
  ReaderBlock,
  ReaderBlockSchema,
  ReaderDocumentSchema,
  renderToStaticMarkup
};
